/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于编写测试用例: 走点界面功能
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 巫昭雯
 *      时间 : 2021.5.18
 *      内容 : 所有代码
 *************************************************************************************************/

/* exported tc_point_init_data */
/* exported tc_point_switch_mode */
/* exported tc_point_switch_layout */
/* exported tc_point_insert_virtual_point */
/* exported tc_point_random_click */
/* exported tc_point_go_back */
/* exported tc_point_reset */
/* exported tc_point_zoom_in */
/* exported tc_point_zoom_out */
/* exported tc_point_modify_sweep */
/* exported tc_point_modify_chip */
/* exported tc_point_fill */


/* global $ */
/* global get_webui_pop_leyer */
/* global mc_util_get_url_page_name */
/* global get_webui_main_document */
/* global tc_tool_go_home */
/* global tc_tool_close_all_layer */
/* global tc_tool_get_random_idx */


// 走点页面选择器
var g_selector_str_svg = "#mc_trace_point_wrap .mc_svg_main_wrap svg";
var g_selector_str_point = "#mc_trace_point_wrap .click_create_div";

/************************************************************************************************
 * 类型:
 *    测试用例函数
 * 功能:
 *    页面初始化打开走点界面; 校验数据
 * 参数:
 *    @param { Promise<Function> } callback
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-20
 *       内容 : 所有代码
 ************************************************************************************************/
function tc_point_init_data(callback) {
    tc_point_open_layout(function (err) {
        if (!err) {
            callback(0, "打开界面出错");
            return;
        }


        // svg_item_content_rect
        var o_layer = get_webui_pop_leyer();
        var o_doc = tc_point_get_layer_doc(o_layer);

        if (o_doc) {
            // var o_click = o_doc.getElementById("mc_trace_point_wrap").children[0].children[0];
            // var o_svg = $(o_click).find(".mc_svg_main_wrap").find("svg");

            // o_svg.mousedown({
            //     button: 0
            // });

            callback(1);
            return;
        }

        callback(0);
        return;
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    打开走点页面; 流程: 主页-模组向导按钮-走点
 * 参数:
 *    @param { Promise<Function> } callback (true === 正常打开)
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-20
 *       内容 : 所有代码
 ************************************************************************************************/
function tc_point_open_layout(callback) {
    if ("function" !== typeof callback) {
        return;
    }

    var o_doc = tc_point_get_layer_doc(get_webui_pop_leyer());

    if (o_doc) {
        tc_tool_close_all_layer();
        get_webui_main_document().getElementById("mc_btn_id_open_trace_point").click();
        setTimeout(() => {
            return callback(true);
        }, 1000);
        return;
    }

    // reset go home and open
    tc_tool_go_home(function () {
        get_webui_main_document().getElementById("btn_id_mod_wizard").click();
        setTimeout(function () {
            get_webui_main_document().getElementById("mc_btn_id_open_trace_point").click();
            setTimeout(() => {
                return callback(true);
            }, 1000);
        }, 1000);
    });
}


/************************************************************************************************
 * 类型:
 *    内部函数
 * 功能:
 *    判断当前layer是否为'走点'页面 && 获取document 对象
 * 参数:
 *    @param { Promise<Object> } el layer 层对象
 * 返回:
 *    @returns { Promise<Object> } 走点页面 document
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-21
 *       内容 : 所有代码
 ************************************************************************************************/
function tc_point_get_layer_doc(el) {
    if (el && "function" === typeof el.querySelector) {
        var o_iframe = el.querySelector("iframe");

        if (o_iframe) {
            var str_page_name = mc_util_get_url_page_name(o_iframe.src);

            if ("svg_table.html" === str_page_name) {
                return o_iframe.contentDocument;
            }
        }

        return false;
    }

    return false;
}


/************************************************************************************************
 * 类型:
 *    内置函数
 * 功能:
 *    封装函数; 获取走点页面document; 若当前页面已打开 -> 直接回调; 否则回到主页重新打开走点页面;
 * 参数:
 *    @param { Promise<String> } callback 打开页面之后的回调函数;
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    callback(param); 回调参数param === 走点页面document
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-25
 *       内容 : 所有代码
************************************************************************************************/
function tc_point_pakeage_get_doc(callback) {
    var o_doc = tc_point_get_layer_doc(get_webui_pop_leyer());

    if (o_doc) {
        callback(o_doc);
        return;
    }

    tc_point_open_layout(function () {
        callback(tc_point_get_layer_doc(get_webui_pop_leyer()));
    });
}

/************************************************************************************************
 * 类型:
 *    测试用例函数
 * 功能:
 *    切换走点模式(高级走点)
 * 参数:
 *    @param { Promise<Function> } callback 用例callback
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-21
 *       内容 : 所有代码
 ************************************************************************************************/
function tc_point_switch_mode(callback) {
    tc_point_pakeage_get_doc(function (o_doc) {
        // 点击切换按钮
        // mc_trace_point_hl
        var o_btn = $(o_doc).find("#mc_trace_point_hl [lang_id='MC_LANG_HEGH_LEVER_TRACE_POINT']").next();

        if (o_btn.length) {
            o_btn.click();
            callback(1);
            return;
        }

        callback(0, "切换高级走点模式出错");
    });
}


/************************************************************************************************
 * 类型:
 *    测试用例函数
 * 功能:
 *    插入虚点值
 * 参数:
 *    @param { Promise<Function> } callback 测试用例回调函数
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-24
 *       内容 : 所有代码
 ************************************************************************************************/
function tc_point_insert_virtual_point(callback) {
    tc_point_pakeage_get_doc(function (o_doc) {
        var obj = $(o_doc).find("div[lang_id=MC_LANG_INSRET_VIRTUAL_POINT]");

        if (!obj) {
            callback(0, "未获取到'插入虚点'按钮");
        }

        tc_point_swich_virtual_val(o_doc);
        setTimeout(() => {
            var ui_old_virtual = Number(o_doc.querySelector(".div_hover_content").innerText.replace("[", "").replace("]", ""));
            var ui_cur_step = tc_point_get_cur_virtual_point_step_val(o_doc);

            if (!ui_cur_step) {
                callback(0, "未获取到当前虚点值");
                return;
            }

            obj.click();

            setTimeout(() => {
                var o_virtual = o_doc.querySelectorAll(".div_hover_content");
                var ui_len = o_virtual.length;

                for (var i = 0; i < ui_len; i++) {
                    var el = o_virtual[i];

                    if (Number(el.innerText.replace("[", "").replace("]", "")) !== Number(ui_old_virtual) + Number(ui_cur_step)) {
                        callback(0, "插入虚点值数据错误");
                        return;
                    }
                }
                callback(1, "显示的虚点值正确");
            }, 500);
        }, 1000);
    });
}


// 获取当前虚点值
function tc_point_get_cur_virtual_point_step_val(o_doc) {
    var obj = $(o_doc).find("[lang_id=MC_LANG_INSRET_VIRTUAL_POINT_VAL]");

    if (0 === obj.length) {
        return false;
    }

    return obj.next().find("input").val();
}


// 切换虚点值; 步进编辑框
function tc_point_swich_virtual_val(o_doc) {
    var obj = $(o_doc).find("[lang_id=MC_LANG_INSRET_VIRTUAL_POINT_VAL]");

    if (0 === obj.length) {
        return false;
    }

    var o_btn_add = $(obj).next().find(".mc_step_add");

    o_btn_add.click();
    return true;
}


/************************************************************************************************
 * 类型:
 *    测试用例函数
 * 功能:
 *    切换布局(横向/纵向)
 * 参数:
 *    @param { Promise<Function> } callback 用例 callback
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-24
 *       内容 : 所有代码
 ************************************************************************************************/
function tc_point_switch_layout(callback) {
    tc_point_pakeage_get_doc(function (o_doc) {
        // 设置为 "高级走点模式"; on === true
        if (is_hl_mode()) {
            do_switch_layout();
            return;
        }

        tc_point_switch_mode(function (code, msg) {
            if (0 === code) {
                callback(0, msg);
                return;
            }

            setTimeout(() => {
                return do_switch_layout();
            }, 1000);
        });

        // 执行 "切换"
        function do_switch_layout() {
            var o_hl = $(o_doc).find("#mc_trace_point_hl [lang_id=MC_LANG_HEGH_LEVER_TRACE_POINT_VERTICAL_LAYOUT]");

            if (o_hl.length) {
                o_hl.next().click();
                callback(1);
                return;
            }

            callback(0, "切换布局按钮不存在");
            return;
        }

        // 是否为高级模式
        function is_hl_mode() {
            var $o_btn_hl = $(o_doc).find("#mc_trace_point_hl [lang_id='MC_LANG_HEGH_LEVER_TRACE_POINT']").next();

            if ("true" === $o_btn_hl.attr("checkbox_select")) {
                return true;
            }

            return false;
        }
    });
}

/************************************************************************************************
 * 类型:
 *    测试用例函数
 * 功能:
 *    随机生成描点
 * 参数:
 *    @param { Promise<Function> } callback
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    随机8次
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-24
 *       内容 : 所有代码
************************************************************************************************/
function tc_point_random_click(callback) {
    tc_point_pakeage_get_doc(function (o_doc) {
        // mc_svg_main_wrap
        var $o_svg = $(o_doc).find(g_selector_str_svg);
        var o_svg = $o_svg[0];
        var o_ev_down = new CustomEvent("mousedown");
        var o_ev_up = new CustomEvent("mouseup");

        o_svg.dispatchEvent(new MouseEvent("mousemove"));
        o_ev_down.button = 0;
        o_ev_up.button = 0;

        var ui_i = 0;
        var ui_timer = setInterval(() => {
            if (8 < ui_i) {
                clearInterval(ui_timer);
                callback(1, "随机个数" + 8);
                return;
            }

            ui_i++;
            var ui_xy = tc_point_get_ramdom_pos(o_svg);

            // console.log("[位置]", ui_xy);

            if (!has_block(ui_xy.X, ui_xy.Y)) {
                o_ev_down.offsetX = ui_xy.X;
                o_ev_down.offsetY = ui_xy.Y;
                o_ev_up.offsetX = ui_xy.X;
                o_ev_up.offsetY = ui_xy.Y;

                o_svg.dispatchEvent(o_ev_down);
                o_svg.dispatchEvent(o_ev_up);
            }
        }, 100);


        function has_block(x, y) {
            var a_block = $(o_doc).find(g_selector_str_point);
            var ui_len = a_block.length;

            for (let i = 0; i < ui_len; i++) {
                const ele = a_block[i];

                if ((ele.offsetWidth + ele.offsetLeft) >= x && x >= ele.offsetLeft && (ele.offsetHeight + ele.offsetTop) >= y && y >= ele.offsetTop) {
                    return true;
                }
            }

            return false;
        }
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取随机位置值
 * 参数:
 *    @param { Promise<Object> } obj svg 走点内置对象
 * 返回:
 *    @returns { Promise<Object> } {X: offsetX; Y:offsetY }
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-25
 *       内容 : 所有代码
************************************************************************************************/
function tc_point_get_ramdom_pos(obj) {
    if (!obj) {
        return {};
    }

    return {
        X: tc_tool_get_random_idx(obj.scrollWidth) + 1,
        Y: tc_tool_get_random_idx(obj.scrollHeight) + 1
    };
}


/************************************************************************************************
 * 类型:
 *    测试用例函数
 * 功能:
 *    重新走点
 * 参数:
 *    @param { Promise<Function> } callback
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-24
 *       内容 : 所有代码
************************************************************************************************/
function tc_point_reset(callback) {
    // MC_LANG_GO_BACK
    tc_point_pakeage_get_doc(function (o_doc) {
        setTimeout(() => {
            var o_btn = $(o_doc).find("[lang_id=MC_LANG_GO_BACK]");

            o_btn.click();
            callback(1);
        }, 1000);
    });
}


/************************************************************************************************
 * 类型:
 *    测试用例函数
 * 功能:
 *    回撤走点
 * 参数:
 *    @param { Promise<Function> } callback
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-24
 *       内容 : 所有代码
************************************************************************************************/
function tc_point_go_back(callback) {
    tc_point_pakeage_get_doc((o_doc) => {
        var o_btn = $(o_doc).find("div[lang_id=MC_LANG_RETREAT]");
        var ui_i = 0;
        var ui_timer = setInterval(() => {
            if (3 < ui_i) {
                clearInterval(ui_timer);
                callback(1, "回撤3次");
                return;
            }
            ui_i++;
            o_btn.click();
        }, 100);
    });
}


/************************************************************************************************
 * 类型:
 *    内置函数
 * 功能:
 *    缩放测试用例函数调用;
 * 参数:
 *    @param { Promise<Number> } ui_zoom === 1 (放大)
 *    @param { Promise<Function> } callback
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-25
 *       内容 : 所有代码
************************************************************************************************/
function tc_point_zoom(ui_zoom, callback) {
    // ui_zoom === 1 === 放大
    var o_ev_mouse = new CustomEvent("mousewheel");

    o_ev_mouse.ctrlKey = true;
    o_ev_mouse.wheelDelta = 1 === ui_zoom ? 10 : -10;
    var fn_zoom = 1 === ui_zoom ? "mc_lang_zoom_in_point" : "mc_lang_zoom_out_point";

    tc_point_pakeage_get_doc(function (o_doc) {
        o_doc.defaultView.dispatchEvent(o_ev_mouse);
        setTimeout(() => {
            if ("function" === typeof o_doc.defaultView[fn_zoom]) {
                o_doc.defaultView[fn_zoom]();
                setTimeout(() => {
                    callback(1, "执行两次: 1. 按钮事件; 2.鼠标快捷键");
                }, 500);
                return;
            }
        }, 500);
    });
}


// 放大; 测试用例函数
function tc_point_zoom_in(callback) {
    tc_point_zoom(1, callback);
}


// 缩小; 测试用例函数
function tc_point_zoom_out(callback) {
    tc_point_zoom(0, callback);
}

/************************************************************************************************
 * 类型:
 *    测试用例函数
 * 功能:
 *    修改行扫数;
 * 参数:
 *    @param { Promise<Function> } callback
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    修改当前点行扫数; 若当前不存在点;则生成一个点并修改
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-25
 *       内容 : 所有代码
************************************************************************************************/
function tc_point_modify_sweep(callback) {
    tc_point_pakeage_get_doc(function (o_doc) {
        var ui_len = $(o_doc).find(g_selector_str_point).length;
        var ui_time = 0 === ui_len ? 1000 : 0;

        if (0 === ui_len) {
            var $o_svg = $(o_doc).find(g_selector_str_svg);
            var o_svg = $o_svg[0];
            var o_ev_down = new CustomEvent("mousedown");
            var o_ev_up = new CustomEvent("mouseup");
            var ui_xy = tc_point_get_ramdom_pos(o_svg);

            o_ev_down.button = 0;
            o_ev_down.offsetX = ui_xy.X;
            o_ev_down.offsetY = ui_xy.Y;

            o_ev_up.button = 0;
            o_ev_up.offsetX = ui_xy.X;
            o_ev_up.offsetY = ui_xy.Y;

            o_svg.dispatchEvent(new MouseEvent("mousemove"));
            o_svg.dispatchEvent(o_ev_down);
            o_svg.dispatchEvent(o_ev_up);
        }

        setTimeout(() => {
            var o_sweep = $(o_doc).find("#mc_trace_point_sweep [lang_id=MC_LANG_SWEEP]").next().find(".mc_step_add");

            o_sweep.click();
            callback(1);
        }, ui_time);
    });
}

/************************************************************************************************
 * 类型:
 *    测试用例函数
 * 功能:
 *    修改芯片数量
 * 参数:
 *    @param { Promise<Function> } callback
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-25
 *       内容 : 所有代码
************************************************************************************************/
function tc_point_modify_chip(callback) {
    tc_point_pakeage_get_doc(function (o_doc) {
        $(o_doc).find("#mc_trace_chip_cnt [lang_id=MC_LANG_CHIP_CNT]").next().find(".mc_step_add").click();
        return callback(1);
    });
}


/************************************************************************************************
 * 类型:
 *    测试用例函数
 * 功能:
 *    填充功能
 * 参数:
 *    @param { Promise<Function> } callback
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    随机描三个连续的点->填充
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-25
 *       内容 : 所有代码
************************************************************************************************/
function tc_point_fill(callback) {
    tc_point_open_layout(function () {
        var o_doc = tc_point_get_layer_doc(get_webui_pop_leyer());
        var $o_svg = $(o_doc).find(g_selector_str_svg);
        var o_svg = $o_svg[0];
        var o_ev_down = new CustomEvent("mousedown");
        var o_ev_up = new CustomEvent("mouseup");

        o_svg.dispatchEvent(new CustomEvent("mousemove"));

        o_ev_down.button = 0;
        o_ev_up.button = 0;

        var ui_x = tc_tool_get_random_idx(o_svg.scrollWidth);

        // console.log(ui_x);

        var ui_y = 0;
        var ui_i = 0;
        var ui_timer = setInterval(() => {
            if (2 < ui_i) {
                clearInterval(ui_timer);
                setTimeout(() => {
                    click_fill();
                }, 500);
                return;
            }
            ui_i++;
            o_ev_down.offsetX = ui_x;
            o_ev_down.offsetY = ui_y + (25 * ui_i);
            o_ev_up.offsetX = ui_x;
            o_ev_up.offsetY = ui_y + (25 * ui_i);
            o_svg.dispatchEvent(o_ev_down);
            o_svg.dispatchEvent(o_ev_up);
        }, 100);


        function click_fill() {
            // MC_LANG_FILLING_POINT
            var o_btn_fill = $(o_doc).find(".mc_btn_group [lang_id='MC_LANG_FILLING_POINT']");

            o_btn_fill.click();
            setTimeout(() => {
                return callback(1, "随机描三个连续的点->填充");
            }, 2000);
            return;
        }
    });
}


/************************************************************************************************
 * 类型:
 *    测试用例函数
 * 功能:
 *    数据线切换
 * 参数:
 *    @param { Promise<Function> } callback
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-25
 *       内容 : 所有代码
************************************************************************************************/
function tc_point_switch_data_line(callback) {

}
